package com.ving.gasmileage;

import android.content.Context;
import android.content.ContentResolver;
import android.database.Cursor;
import android.provider.DocumentsContract;
import android.net.Uri;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class ReadMileageData {
    private Context mContext;
    private Uri externDir;
    private Uri parentDocumentUri = null;
    private ContentResolver contentResolver = null;
    private String csvFile = null;
    private Boolean newFile = false;
    private Uri myFile = null;
    private ArrayList<String> rowData = null;
    private ArrayList<MileageData> mileageData = null;
    private String errorMsg = "";
    private String subErrorMsg = "";
    private MileageData md = null;

    ReadMileageData(Context context, Uri uri, String fileName, Boolean newFile) {
        this.mContext = context;
        this.externDir = uri;
        this.csvFile = fileName;
        this.newFile = newFile;
    }

    public String error() {
        return errorMsg + "\n" + subErrorMsg;
    }
    
    private Uri findFileInDirectory(String filename) {
        Uri rtn = null;

        try {
            Cursor cursor = contentResolver.query(parentDocumentUri,
                    new String[]{DocumentsContract.Document.COLUMN_DOCUMENT_ID, DocumentsContract.Document.COLUMN_DISPLAY_NAME},
                    null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    String displayName = cursor.getString(cursor.getColumnIndexOrThrow(DocumentsContract.Document.COLUMN_DISPLAY_NAME));
                    if (displayName.equals(filename)) {
                        String documentId = cursor.getString(cursor.getColumnIndexOrThrow(DocumentsContract.Document.COLUMN_DOCUMENT_ID));
                        rtn = DocumentsContract.buildDocumentUriUsingTree(externDir, documentId);
                    }
                } while (cursor.moveToNext());
                cursor.close();
            }
        } catch (Exception e) {
            subErrorMsg = e.toString();
        }
        if (rtn == null) {
            errorMsg = "Unable to find file " + filename;
        }
        return rtn;
    }

    public Boolean setUpData() {
        Boolean rtn = true;
        try {
            contentResolver = mContext.getContentResolver();
        } catch (Exception e) {
            errorMsg = "Sorry, there was an error trying to initialize the data.";
            subErrorMsg = e.toString();
            rtn = false;
        }
        if (rtn) {
            parentDocumentUri = DocumentsContract.buildChildDocumentsUriUsingTree(
                    externDir,
                    DocumentsContract.getTreeDocumentId(externDir)
            );
            if (parentDocumentUri == null) {
                rtn = false;
                errorMsg = "Cannot read storage directory.";
            } else {
                myFile = findFileInDirectory(csvFile);
                if (myFile == null && !newFile) {
                    rtn = false;
                    errorMsg = "Unable to find CSV file "+csvFile+" in directory.";
                }
            }
        }
        return rtn;
    }

    public Boolean readFile() {
        Boolean rtn = true;
        mileageData = new ArrayList<MileageData>();
        if (myFile != null) {
            try {
                InputStream iStream = contentResolver.openInputStream(myFile);
                if (iStream != null) {
                    BufferedReader myReader = new BufferedReader(new InputStreamReader(iStream));
                    String row;
                    rowData = new ArrayList<String>();
                    while ((row = myReader.readLine()) != null) {
                        rowData.add(row);
                    }
                    myReader.close();
                    iStream.close();
                } else {
                    errorMsg = "Sorry, there was an error trying to read the CSV file.";
                    subErrorMsg = "Unable to open the CSV file: " + csvFile;
                }
            } catch (Exception e) {
                errorMsg = "Error reading CSV file: " + csvFile;
                subErrorMsg = e.toString();
                rtn = false;
            }
            if (rtn) {
                for (String row : rowData) {
                    if (!row.isEmpty()) {
                        String[] rowValues = row.split(",");
                        try {
                            md = new MileageData(rowValues);
                            mileageData.add(md);
                        } catch (Exception e) {
                            rtn = false;
                            errorMsg = "Error saving Data from CSV file: " + csvFile;
                            subErrorMsg += "\n   " + row + "\n   " + e.toString();
                        }
                    }
                }
            }
        }
        if (! rtn) {
            mileageData = null;
        }
        return rtn;
    }
    
    public ArrayList<MileageData> getMileageData() {
        return mileageData;
    }
}
