package com.ving.gasmileage;

import android.content.Context;
import android.content.ContentResolver;
import android.database.Cursor;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.provider.DocumentsContract;

public class WriteMileageData {

    private MyApplication myApp = null;
    private final Context mContext;
    private ContentResolver contentResolver = null;
    private Uri externDir = null;
    private Uri parentDocumentUri = null;
    private String csvFile = null;
    private Uri myFile = null;
    private Uri backupFile = null;
    private String errorMsg = "";
    private String subErrorMsg = "";
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private InitData.OnInitCompleteListener mListener;

    WriteMileageData(Uri externDir, String fileName, MyApplication myApp, Context context) {
        this.externDir = externDir;
        this.csvFile = fileName;
        this.myApp = myApp;
        this.mContext = context;
    }
    
    public String error() {
        return errorMsg + "\n" + subErrorMsg;
    }

    private Uri findFileInDirectory(String filename) {
        Uri rtn = null;

        try {
            Cursor cursor = contentResolver.query(parentDocumentUri,
                    new String[]{DocumentsContract.Document.COLUMN_DOCUMENT_ID, DocumentsContract.Document.COLUMN_DISPLAY_NAME},
                   null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    String displayName = cursor.getString(cursor.getColumnIndexOrThrow(DocumentsContract.Document.COLUMN_DISPLAY_NAME));
                    if (displayName.equals(filename)) {
                        String documentId = cursor.getString(cursor.getColumnIndexOrThrow(DocumentsContract.Document.COLUMN_DOCUMENT_ID));
                        rtn = DocumentsContract.buildDocumentUriUsingTree(externDir, documentId);
                    }
                } while (cursor.moveToNext());
                cursor.close();
            }
        } catch (Exception e) {
            subErrorMsg = e.toString();
            rtn = null;
        }
        if (rtn == null) {
            subErrorMsg = "Unable to find file " + filename;
        }
        return rtn;
    }

    public boolean initData() {
        boolean rtn = true;
        try {
            contentResolver = mContext.getContentResolver();
        } catch (Exception e) {
            errorMsg = "Sorry, there was an error trying to initialize the data.";
            subErrorMsg = e.toString();
            rtn = false;
        }
        if (rtn) {
            parentDocumentUri = DocumentsContract.buildChildDocumentsUriUsingTree(
                    externDir,
                    DocumentsContract.getTreeDocumentId(externDir)
            );
            if (parentDocumentUri == null) {
                rtn = false;
                errorMsg = "Cannot read storage directory.";
            } else {
                myFile = findFileInDirectory(csvFile);
                //if (myFile == null) {
                //    rtn = false;
                //    errorMsg = "Unable to find CSV file in directory.";
                //}
                backupFile = findFileInDirectory(csvFile + ".backup");
            }
        }
        return rtn;
    }

    public boolean backupFile() {
        boolean rtn = true;
        ContentResolver contentResolver = mContext.getContentResolver();
        if (myFile != null) {
            try {
                if (backupFile == null) {
                    backupFile = DocumentsContract.createDocument(contentResolver, parentDocumentUri, "application/octet-stream", csvFile + ".backup");
                }
                if (backupFile == null) {
                    errorMsg = "Unable to create backup file.";
                    subErrorMsg = "";
                    rtn = false;
                } else {
                    InputStream iStream = contentResolver.openInputStream(myFile);
                    OutputStream oStream = contentResolver.openOutputStream(backupFile, "wt");
                    if (oStream != null && iStream != null) {
                        byte[] buffer = new byte[1024];
                        int read;
                        while ((read = iStream.read(buffer)) != -1) {
                            oStream.write(buffer, 0, read);
                        }
                        iStream.close();
                        iStream = null;
                        oStream.flush();
                        oStream.close();
                        oStream = null;
                    } else {
                        rtn = false;
                        errorMsg = "Unable to save the backup file";
                        subErrorMsg = "Unable to open the backup file for writing";
                    }
                }
            } catch (Exception e) {
                rtn = false;
                errorMsg = "Sorry, there was an error trying to backup the CSV file.";
                subErrorMsg = e.toString();
            }
        }
        return rtn;
    }

    public boolean writeData() {
        boolean rtn = true;
        try {
            if (myFile == null) {
                myFile = DocumentsContract.createDocument(contentResolver, parentDocumentUri, "text/csv", csvFile);
                if (myFile == null) {
                    rtn = false;
                    errorMsg = "Sorry, there was an error trying to create the CSV file.";
                    subErrorMsg = "Unable to create the CSV file.";
                }
            }
            if (myFile != null) {
                OutputStream oStream = contentResolver.openOutputStream(myFile, "wt");
                if (oStream != null) {
                    BufferedWriter myWriter = new BufferedWriter(new OutputStreamWriter(oStream));
                    myWriter.write(myApp.toCSV());
                    myWriter.flush();
                    myWriter.close();
                    oStream.close();
                } else {
                    rtn = false;
                    errorMsg = "Sorry, there was an error trying to write the CSV file.";
                    subErrorMsg = "Unable to open the CSV file for writing";
                }
            }
        } catch (Exception e) {
            rtn = false;
            errorMsg = "Sorry, there was an error trying to write the file.";
            subErrorMsg = e.toString();
        }
        return rtn;
    }

}
