package com.ving.gasmileage;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class WriteAsyncTask {

    private MyApplication myApp = null;
    private final Context mContext;
    private Uri externDir = null;
    private String csvFile = null;
    private String task = null;
    private String errorMsg = null;
    private WriteMileageData wmd = null;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private InitData.OnInitCompleteListener mListener;

    WriteAsyncTask(Uri externDir, String fileName, MyApplication myApp, Context context) {
        this.myApp = myApp;
        this.mContext = context;
        this.csvFile = fileName;
        this.externDir = externDir;
    }

    public void setOnWriteCompleteListener(InitData.OnInitCompleteListener listener) {
        this.mListener = listener;
    }

    public void execute() {
        myApp.performingWriteTask();
        executor.execute(() -> {
            wmd = new WriteMileageData(externDir, csvFile, myApp, mContext);
            // Get this ready
            if (!wmd.initData()) {
                task = "Finding CSV file in directory";
                errorMsg = wmd.error();
                mainHandler.post(this::postError);
            } else {
                if (!wmd.backupFile()) {
                    // Make a backup of the CSV file
                    task = "Generating a backup of CSV file";
                    errorMsg = wmd.error();
                    mainHandler.post(this::postError);
                } else {
                    // Save the data in the CSV file
                    if (!wmd.writeData()) {
                        task = "Saving the CSV file";
                        errorMsg = wmd.error();
                        mainHandler.post(this::postError);
                    } else {
                        mainHandler.post(this::onPostExecute);
                    }
                }
            }
        });
    }

    private void onPostExecute() {
        // Notify the MainActivity that the task is complete
        if (mListener != null) {
            mListener.onInitComplete();
        }
    }

    private void postError() {
        // Notify the MainActivity of the error
        if (mListener != null) {
            mListener.onInitError(task + "\n" + errorMsg);
        }
    }

}
